/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors;

import immersive_armors.ItemGroups;
import immersive_armors.armorEffects.ArrowBlockArmorEffect;
import immersive_armors.armorEffects.BerserkArmorEffect;
import immersive_armors.armorEffects.BouncingArmorEffect;
import immersive_armors.armorEffects.DivineArmorEffect;
import immersive_armors.armorEffects.ExplosionProtectionArmorEffect;
import immersive_armors.armorEffects.FireInflictingArmorEffect;
import immersive_armors.armorEffects.FireResistanceArmorEffect;
import immersive_armors.armorEffects.MagicProtectionArmorEffect;
import immersive_armors.armorEffects.SpikesArmorEffect;
import immersive_armors.armorEffects.SteamTechArmorEffect;
import immersive_armors.armorEffects.WeaponEfficiency;
import immersive_armors.armorEffects.WitherArmorEffect;
import immersive_armors.cobalt.registration.Registration;
import immersive_armors.config.Config;
import immersive_armors.item.DyeableExtendedArmorItem;
import immersive_armors.item.ExtendedArmorItem;
import immersive_armors.item.ExtendedArmorMaterial;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1304;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_6862;

public interface Items {
    public static final Map<String, Supplier<class_1792>> coloredItems = new HashMap<String, Supplier<class_1792>>();
    public static final Map<String, Supplier<class_1792>> items = new HashMap<String, Supplier<class_1792>>();
    public static final Map<String, Map<Supplier<class_1792>, Float>> lootLookup = new HashMap<String, Map<Supplier<class_1792>, Float>>();
    public static final ExtendedArmorMaterial BONE_ARMOR = Items.registerSet(new ExtendedArmorMaterial("bone").addLoot("minecraft:chests/village/village_weaponsmith", 1.0f).addLoot("minecraft:chests/jungle_temple", 1.0f).durabilityMultiplier(8).repairIngredient(() -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8606})).protectionAmount(1, 3, 2, 1).enchantability(15).equipSound(class_3417.field_15200).antiSkeleton().weight(-0.02f));
    public static final ExtendedArmorMaterial WITHER_ARMOR = Items.registerSet(new ExtendedArmorMaterial("wither").addLoot("minecraft:chests/jungle_temple", 0.5f).addLoot("minecraft:chests/ruined_portal", 1.0f).addLoot("minecraft:chests/bastion_other", 1.0f).durabilityMultiplier(12).repairIngredient(() -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8606})).protectionAmount(2, 4, 3, 2).enchantability(0).effect(new WitherArmorEffect(1.0f, 10)).hideCape().equipSound(class_3417.field_15214).antiSkeleton().weight(-0.01f));
    public static final ExtendedArmorMaterial WARRIOR_ARMOR = Items.registerSet(new ExtendedArmorMaterial("warrior").addLoot("minecraft:chests/village/village_armorer", 1.0f).addLoot("minecraft:chests/shipwreck_supply", 1.0f).protectionAmount(2, 5, 6, 2).durabilityMultiplier(15).repairIngredient(() -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8620})).toughness(1.0f).enchantability(5).hideCape().effect(new BerserkArmorEffect(0.2f)).effect(new WeaponEfficiency(0.05f, class_1743.class, "axe")).equipSound(class_3417.field_14862));
    public static final ExtendedArmorMaterial HEAVY_ARMOR = Items.registerSet(new ExtendedArmorMaterial("heavy").addLoot("minecraft:chests/village/village_armorer", 1.0f).addLoot("minecraft:chests/stronghold_crossing", 1.0f).protectionAmount(4, 6, 5, 3).durabilityMultiplier(20).repairIngredient(() -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8620})).toughness(4.0f).knockbackReduction(0.5f).weight(0.05f).enchantability(6).equipSound(class_3417.field_14862));
    public static final ExtendedArmorMaterial ROBE_ARMOR = Items.registerDyeableSet(new ExtendedArmorMaterial("robe").addLoot("minecraft:chests/village/village_shepherd", 0.25f).addLoot("minecraft:chests/woodland_mansion", 1.0f).addLoot("minecraft:chests/igloo_chest", 1.0f).protectionAmount(2, 3, 2, 1).enchantability(50).durabilityMultiplier(14).repairIngredient(() -> class_1856.method_8106((class_6862)class_3489.field_15544)).color(11546150).effect(new FireResistanceArmorEffect(0.25f)).effect(new FireInflictingArmorEffect(10)).effect(new MagicProtectionArmorEffect(0.2f)).equipSound(class_3417.field_15226));
    public static final ExtendedArmorMaterial SLIME_ARMOR = Items.registerSet(new ExtendedArmorMaterial("slime").addLoot("minecraft:chests/simple_dungeon", 0.25f).protectionAmount(3, 5, 4, 2).enchantability(10).durabilityMultiplier(20).repairIngredient(() -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8777})).knockbackReduction(0.25f).effect(new BouncingArmorEffect(0.25f)).effect(new ExplosionProtectionArmorEffect(0.2f)).equipSound(class_3417.field_15095));
    public static final ExtendedArmorMaterial DIVINE_ARMOR = Items.registerDyeableSet(new ExtendedArmorMaterial("divine").addLoot("minecraft:chests/village/village_temple", 0.4f).addLoot("minecraft:chests/bastion_treasure", 0.25f).addLoot("minecraft:chests/woodland_mansion", 0.25f).addLoot("minecraft:chests/desert_pyramid", 1.0f).addLoot("minecraft:blocks/coal_block", 0.1f).protectionAmount(3, 7, 5, 3).durabilityMultiplier(18).repairIngredient(() -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8695})).enchantability(30).effect(new DivineArmorEffect(1200L)).color(11546150).hideCape().equipSound(class_3417.field_14862));
    public static final ExtendedArmorMaterial PRISMARINE_ARMOR = Items.registerSet(new ExtendedArmorMaterial("prismarine").addLoot("minecraft:chests/underwater_ruin_big", 1.0f).addLoot("minecraft:chests/underwater_ruin_small", 0.5f).protectionAmount(3, 8, 6, 3).enchantability(8).durabilityMultiplier(18).repairIngredient(() -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8434})).weight(0.02f).effect(new SpikesArmorEffect(1)).enchantment(class_1893.field_9128, 2).equipSound(class_3417.field_14862));
    public static final ExtendedArmorMaterial WOODEN_ARMOR = Items.registerSet(new ExtendedArmorMaterial("wooden").addLoot("minecraft:chests/village/village_fletcher", 0.25f).protectionAmount(1, 3, 2, 1).durabilityMultiplier(8).repairIngredient(() -> class_1856.method_8106((class_6862)class_3489.field_15539)).enchantability(4).effect(new ArrowBlockArmorEffect(0.15f)).effect(new ExplosionProtectionArmorEffect(0.1f)).equipSound(class_3417.field_14581));
    public static final ExtendedArmorMaterial STEAMPUNK_ARMOR = Items.registerSet(new ExtendedArmorMaterial("steampunk").addLoot("minecraft:chests/village/village_toolsmith", 0.25f).addLoot("minecraft:chests/shipwreck_treasure", 1.0f).protectionAmount(3, 6, 3, 2).durabilityMultiplier(10).repairIngredient(() -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8695})).enchantability(4).hideCape().effect(new ExplosionProtectionArmorEffect(0.1f)).effect(new SteamTechArmorEffect()).equipSound(class_3417.field_19199));

    public static void bootstrap() {
    }

    public static ExtendedArmorMaterial registerSet(ExtendedArmorMaterial material) {
        if (Config.getInstance().enabledArmors.getOrDefault(material.method_7694(), true).booleanValue()) {
            items.putAll(Items.register(material.method_7694() + "_helmet", () -> new ExtendedArmorItem(Items.baseProps(), class_1304.field_6169, material), material));
            items.putAll(Items.register(material.method_7694() + "_chestplate", () -> new ExtendedArmorItem(Items.baseProps(), class_1304.field_6174, material), material));
            items.putAll(Items.register(material.method_7694() + "_leggings", () -> new ExtendedArmorItem(Items.baseProps(), class_1304.field_6172, material), material));
            items.putAll(Items.register(material.method_7694() + "_boots", () -> new ExtendedArmorItem(Items.baseProps(), class_1304.field_6166, material), material));
        }
        return material;
    }

    public static ExtendedArmorMaterial registerDyeableSet(ExtendedArmorMaterial material) {
        if (Config.getInstance().enabledArmors.getOrDefault(material.method_7694(), true).booleanValue()) {
            coloredItems.putAll(Items.register(material.method_7694() + "_helmet", () -> new DyeableExtendedArmorItem(Items.baseProps(), class_1304.field_6169, material), material));
            coloredItems.putAll(Items.register(material.method_7694() + "_chestplate", () -> new DyeableExtendedArmorItem(Items.baseProps(), class_1304.field_6174, material), material));
            coloredItems.putAll(Items.register(material.method_7694() + "_leggings", () -> new DyeableExtendedArmorItem(Items.baseProps(), class_1304.field_6172, material), material));
            coloredItems.putAll(Items.register(material.method_7694() + "_boots", () -> new DyeableExtendedArmorItem(Items.baseProps(), class_1304.field_6166, material), material));
            items.putAll(coloredItems);
        }
        return material;
    }

    public static Map<String, Supplier<class_1792>> register(String name, Supplier<class_1792> item, ExtendedArmorMaterial material) {
        Supplier<class_1792> register = Registration.register(class_2378.field_11142, new class_2960("immersive_armors", name), item);
        for (Map.Entry<String, Float> entry : material.getLoot().entrySet()) {
            lootLookup.putIfAbsent(entry.getKey(), new HashMap());
            lootLookup.get(entry.getKey()).put(register, entry.getValue());
        }
        return Collections.singletonMap(name, register);
    }

    public static class_1792.class_1793 baseProps() {
        return new class_1792.class_1793().method_7892(ItemGroups.ARMOR);
    }
}

